<?php
namespace App\Contracts;

use App\Http\Requests\Auth\LoginRequest;
use App\Http\Requests\Auth\RegisterUserRequest;
use App\Models\User;
use Illuminate\Http\Request;

interface AuthServiceInterface
{
  public function authenticate(LoginRequest $request): User;
  public function logout(Request $request);
  public function checkIfVerified(Request $request): bool;
  public function sendVerificationEmail(Request $request);
  public function resetPassword(Request $request);
  public function resetPasswordLink(Request $request);
  public function registerUser(RegisterUserRequest $request): User;

  public function createStringAuthToken(User $user): string;

  public function approveUser(User $user): bool;
  public function rejectUser(User $user): bool;
  public function blockUser(User $user): bool;

}