<?php

namespace App\Http\Controllers\Auth;

use App\Contracts\AuthServiceInterface;
use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\RegisterUserRequest;
use App\Http\Resources\Auth\UserAuthResource;
use Illuminate\Http\JsonResponse;

class RegisteredUserController extends Controller
{
    protected $service;

    public function __construct(AuthServiceInterface $service)
    {
        $this->service = $service;
    }

    /**
     * Handle an incoming registration request.
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(RegisterUserRequest $request): JsonResponse
    {
        $user = $this->service->registerUser($request);

        return (new UserAuthResource($request))
                ->additional(['token' => $this->service->createStringAuthToken($user)])
                ->response()->setStatusCode(201);
    }
}
