<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserRoleController;


Route::middleware(['auth:sanctum', 'verified'])->prefix('user-role')->group(function () {
  Route::get('/', [UserRoleController::class, 'index'])->name('user-role.index');
  Route::get('/{id}', [UserRoleController::class, 'show'])->name('user-role.show');
  Route::post('/', [UserRoleController::class, 'store'])->name('user-role.store');
  Route::put('/{user}/{role}', [UserRoleController::class, 'update'])->name('user-role.update');
  Route::delete('/{id}', [UserRoleController::class, 'destroy'])->name('user-role.destroy');
});